/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class BroadcastStream
extends Stream {
    final Stream[] streams;
    private static final Primitive MAKE_BROADCAST_STREAM = new Primitive("make-broadcast-stream", "&rest streams"){

        public LispObject execute() {
            return new BroadcastStream(new Stream[0]);
        }

        public LispObject execute(LispObject[] args) {
            Stream[] streams = new Stream[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof Stream) {
                    if (!((Stream)args[i]).isOutputStream()) {
                        return Lisp.type_error(args[i], Lisp.list(Symbol.SATISFIES, Symbol.OUTPUT_STREAM_P));
                    }
                } else {
                    return Lisp.type_error(args[i], Symbol.STREAM);
                }
                streams[i] = (Stream)args[i];
            }
            return new BroadcastStream(streams);
        }
    };
    private static final Primitive BROADCAST_STREAM_STREAMS = new Primitive("broadcast-stream-streams", "broadcast-stream"){

        public LispObject execute(LispObject arg) {
            if (arg instanceof BroadcastStream) {
                BroadcastStream stream = (BroadcastStream)arg;
                Stream[] streams = stream.streams;
                LispObject result = Lisp.NIL;
                int i = streams.length;
                while (i-- > 0) {
                    result = new Cons(streams[i], result);
                }
                return result;
            }
            return Lisp.type_error(arg, Symbol.BROADCAST_STREAM);
        }
    };

    BroadcastStream(Stream[] streams) {
        super(Symbol.BROADCAST_STREAM);
        this.streams = streams;
        this.isOutputStream = true;
        if (streams.length == 0) {
            this.elementType = Lisp.T;
            this.isBinaryStream = true;
            this.isCharacterStream = true;
        } else {
            this.elementType = streams[streams.length - 1].getElementType();
            if (this.elementType == Symbol.CHARACTER || this.elementType == Symbol.BASE_CHAR) {
                this.isCharacterStream = true;
            } else {
                this.isBinaryStream = true;
            }
        }
    }

    public Stream[] getStreams() {
        return this.streams;
    }

    public LispObject typeOf() {
        return Symbol.BROADCAST_STREAM;
    }

    public LispObject classOf() {
        return BuiltInClass.BROADCAST_STREAM;
    }

    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.BROADCAST_STREAM) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.BROADCAST_STREAM) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    public LispObject listen() {
        this.notSupported();
        return Lisp.NIL;
    }

    public LispObject fileLength() {
        if (this.streams.length > 0) {
            return this.streams[this.streams.length - 1].fileLength();
        }
        return Fixnum.ZERO;
    }

    public LispObject fileStringLength(LispObject arg) {
        if (this.streams.length > 0) {
            return this.streams[this.streams.length - 1].fileStringLength(arg);
        }
        return Fixnum.ONE;
    }

    protected int _readChar() {
        this.notSupported();
        return -1;
    }

    protected void _unreadChar(int n) {
        this.notSupported();
    }

    protected boolean _charReady() {
        this.notSupported();
        return false;
    }

    public void _writeChar(char c) {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._writeChar(c);
        }
    }

    public void _writeChars(char[] chars, int start, int end) {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._writeChars(chars, start, end);
        }
    }

    public void _writeString(String s) {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._writeString(s);
        }
    }

    public void _writeLine(String s) {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._writeLine(s);
        }
    }

    public int _readByte() {
        this.notSupported();
        return -1;
    }

    public void _writeByte(int n) {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._writeByte(n);
        }
    }

    public void _finishOutput() {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._finishOutput();
        }
    }

    public void _clearInput() {
        this.notSupported();
    }

    protected long _getFilePosition() {
        if (this.streams.length == 0) {
            return 0L;
        }
        return this.streams[this.streams.length - 1]._getFilePosition();
    }

    protected boolean _setFilePosition(LispObject arg) {
        return false;
    }

    public void _close() {
        this.setOpen(false);
    }

    private void notSupported() {
        Lisp.error(new TypeError("Operation is not supported for streams of type BROADCAST-STREAM."));
    }

    public String printObject() {
        return this.unreadableString("BROADCAST-STREAM");
    }
}

