/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractBitVector;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.NilVector;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;

public final class ComplexString
extends AbstractString {
    private int capacity;
    private int fillPointer = -1;
    private boolean isDisplaced;
    private char[] chars;
    private AbstractArray array;
    private int displacement;

    public ComplexString(int capacity) {
        this.capacity = capacity;
        this.chars = new char[capacity];
        this.isDisplaced = false;
    }

    public ComplexString(int capacity, AbstractArray array, int displacement) {
        this.capacity = capacity;
        this.array = array;
        this.displacement = displacement;
        this.isDisplaced = true;
    }

    public LispObject typeOf() {
        return Lisp.list(Symbol.STRING, Lisp.number(this.capacity()));
    }

    public LispObject classOf() {
        return BuiltInClass.STRING;
    }

    public boolean hasFillPointer() {
        return this.fillPointer >= 0;
    }

    public int getFillPointer() {
        return this.fillPointer;
    }

    public void setFillPointer(int n) {
        this.fillPointer = n;
    }

    public void setFillPointer(LispObject obj) {
        if (obj == Lisp.T) {
            this.fillPointer = this.capacity();
        } else {
            int n = Fixnum.getValue(obj);
            if (n > this.capacity()) {
                StringBuffer sb = new StringBuffer("The new fill pointer (");
                sb.append(n);
                sb.append(") exceeds the capacity of the vector (");
                sb.append(this.capacity());
                sb.append(").");
                Lisp.error(new LispError(sb.toString()));
            } else if (n < 0) {
                StringBuffer sb = new StringBuffer("The new fill pointer (");
                sb.append(n);
                sb.append(") is negative.");
                Lisp.error(new LispError(sb.toString()));
            } else {
                this.fillPointer = n;
            }
        }
    }

    public boolean isDisplaced() {
        return this.isDisplaced;
    }

    public LispObject arrayDisplacement() {
        Fixnum value2;
        LispObject value1;
        if (this.array != null) {
            value1 = this.array;
            value2 = Fixnum.getInstance(this.displacement);
        } else {
            value1 = Lisp.NIL;
            value2 = Fixnum.ZERO;
        }
        return LispThread.currentThread().setValues(value1, value2);
    }

    public char[] chars() {
        if (this.chars != null) {
            return this.chars;
        }
        Debug.assertTrue(this.array != null);
        char[] copy = new char[this.capacity];
        if (this.array instanceof AbstractString) {
            System.arraycopy(this.array.chars(), this.displacement, copy, 0, this.capacity);
        } else if (this.array.getElementType() == Symbol.CHARACTER) {
            for (int i = 0; i < this.capacity; ++i) {
                LispObject obj = this.array.AREF(this.displacement + i);
                copy[i] = LispCharacter.getValue(obj);
            }
        } else {
            Lisp.type_error(this.array, Symbol.STRING);
        }
        return copy;
    }

    public char[] getStringChars() {
        if (this.fillPointer < 0) {
            return this.chars();
        }
        char[] ret = new char[this.fillPointer];
        System.arraycopy(this.chars(), 0, ret, 0, this.fillPointer);
        return ret;
    }

    public boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractString) {
            AbstractString string = (AbstractString)obj;
            if (string.length() != this.length()) {
                return false;
            }
            int i = this.length();
            while (i-- > 0) {
                if (string.charAt(i) == this.charAt(i)) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof NilVector) {
            return obj.equal(this);
        }
        return false;
    }

    public boolean equalp(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractString) {
            AbstractString string = (AbstractString)obj;
            if (string.length() != this.length()) {
                return false;
            }
            int i = this.length();
            while (i-- > 0) {
                if (string.charAt(i) == this.charAt(i) || LispCharacter.toLowerCase(string.charAt(i)) == LispCharacter.toLowerCase(this.charAt(i))) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof AbstractBitVector) {
            return false;
        }
        if (obj instanceof AbstractArray) {
            return obj.equalp(this);
        }
        return false;
    }

    public LispObject subseq(int start, int end) {
        SimpleString s = new SimpleString(end - start);
        int i = start;
        int j = 0;
        while (i < end) {
            s.setCharAt(j++, this.charAt(i++));
        }
        return s;
    }

    public void fill(LispObject obj) {
        this.fill(LispCharacter.getValue(obj));
    }

    public void fill(char c) {
        int i = this.length();
        while (i-- > 0) {
            this.setCharAt(i, c);
        }
    }

    public void shrink(int n) {
        if (this.chars != null) {
            if (n < this.capacity) {
                char[] newArray = new char[n];
                System.arraycopy(this.chars, 0, newArray, 0, n);
                this.chars = newArray;
                this.capacity = n;
                this.fillPointer = -1;
                return;
            }
            if (n == this.capacity) {
                return;
            }
        }
        Debug.assertTrue(this.chars == null);
        this.chars = new char[n];
        if (this.array instanceof AbstractString) {
            AbstractString string = (AbstractString)this.array;
            for (int i = 0; i < n; ++i) {
                this.chars[i] = string.charAt(this.displacement + i);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                LispCharacter character = (LispCharacter)this.array.AREF(this.displacement + i);
                this.chars[i] = character.value;
            }
        }
        this.capacity = n;
        this.array = null;
        this.displacement = 0;
        this.isDisplaced = false;
        this.fillPointer = -1;
    }

    public LispObject reverse() {
        int length = this.length();
        SimpleString result = new SimpleString(length);
        int i = 0;
        int j = length - 1;
        while (i < length) {
            result.setCharAt(i, this.charAt(j));
            ++i;
            --j;
        }
        return result;
    }

    public LispObject nreverse() {
        int i = 0;
        for (int j = this.length() - 1; i < j; ++i, --j) {
            char temp = this.charAt(i);
            this.setCharAt(i, this.charAt(j));
            this.setCharAt(j, temp);
        }
        return this;
    }

    public String getStringValue() {
        if (this.fillPointer >= 0) {
            return new String(this.chars(), 0, this.fillPointer);
        }
        return new String(this.chars());
    }

    public Object javaInstance() {
        return new String(this.getStringValue());
    }

    public Object javaInstance(Class c) {
        return this.javaInstance();
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int length() {
        return this.fillPointer >= 0 ? this.fillPointer : this.capacity;
    }

    public char charAt(int index) {
        if (this.chars != null) {
            try {
                return this.chars[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.badIndex(index, this.capacity);
                return '\u0000';
            }
        }
        return LispCharacter.getValue(this.array.AREF(index + this.displacement));
    }

    public void setCharAt(int index, char c) {
        if (this.chars != null) {
            try {
                this.chars[index] = c;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.badIndex(index, this.capacity);
            }
        } else {
            this.array.aset(index + this.displacement, (LispObject)LispCharacter.getInstance(c));
        }
    }

    public LispObject elt(int index) {
        int limit = this.length();
        if (index < 0 || index >= limit) {
            this.badIndex(index, limit);
        }
        return LispCharacter.getInstance(this.charAt(index));
    }

    public LispObject CHAR(int index) {
        return LispCharacter.getInstance(this.charAt(index));
    }

    public LispObject AREF(int index) {
        return LispCharacter.getInstance(this.charAt(index));
    }

    public void aset(int index, LispObject newValue) {
        this.setCharAt(index, LispCharacter.getValue(newValue));
    }

    public void vectorPushExtend(LispObject element) {
        if (this.fillPointer < 0) {
            this.noFillPointer();
        }
        if (this.fillPointer >= this.capacity) {
            this.ensureCapacity(this.capacity * 2 + 1);
        }
        if (this.chars != null) {
            this.chars[this.fillPointer] = LispCharacter.getValue(element);
        } else {
            this.array.aset(this.fillPointer + this.displacement, element);
        }
        ++this.fillPointer;
    }

    public LispObject VECTOR_PUSH_EXTEND(LispObject element) {
        this.vectorPushExtend(element);
        return Fixnum.getInstance(this.fillPointer - 1);
    }

    public LispObject VECTOR_PUSH_EXTEND(LispObject element, LispObject extension) {
        int ext = Fixnum.getValue(extension);
        if (this.fillPointer < 0) {
            this.noFillPointer();
        }
        if (this.fillPointer >= this.capacity) {
            ext = Math.max(ext, this.capacity + 1);
            this.ensureCapacity(this.capacity + ext);
        }
        if (this.chars != null) {
            this.chars[this.fillPointer] = LispCharacter.getValue(element);
        } else {
            this.array.aset(this.fillPointer + this.displacement, element);
        }
        return Fixnum.getInstance(this.fillPointer++);
    }

    public final void ensureCapacity(int minCapacity) {
        if (this.chars != null) {
            if (this.capacity < minCapacity) {
                char[] newArray = new char[minCapacity];
                System.arraycopy(this.chars, 0, newArray, 0, this.capacity);
                this.chars = newArray;
                this.capacity = minCapacity;
            }
        } else {
            Debug.assertTrue(this.array != null);
            if (this.capacity < minCapacity || this.array.getTotalSize() - this.displacement < minCapacity) {
                this.chars = new char[minCapacity];
                int limit = Math.min(this.capacity, this.array.getTotalSize() - this.displacement);
                if (this.array instanceof AbstractString) {
                    AbstractString string = (AbstractString)this.array;
                    for (int i = 0; i < limit; ++i) {
                        this.chars[i] = string.charAt(this.displacement + i);
                    }
                } else {
                    for (int i = 0; i < limit; ++i) {
                        LispCharacter character = (LispCharacter)this.array.AREF(this.displacement + i);
                        this.chars[i] = character.value;
                    }
                }
                this.capacity = minCapacity;
                this.array = null;
                this.displacement = 0;
                this.isDisplaced = false;
            }
        }
    }

    public int sxhash() {
        int hashCode = Lisp.randomStringHashBase;
        int limit = this.length();
        for (int i = 0; i < limit; ++i) {
            hashCode += this.charAt(i);
            hashCode += hashCode << 10;
            hashCode ^= hashCode >> 6;
        }
        hashCode += hashCode << 3;
        hashCode ^= hashCode >> 11;
        hashCode += hashCode << 15;
        return hashCode & Integer.MAX_VALUE;
    }

    public int psxhash() {
        int hashCode = Lisp.randomStringHashBase;
        int limit = this.length();
        for (int i = 0; i < limit; ++i) {
            hashCode += Character.toUpperCase(this.charAt(i));
            hashCode += hashCode << 10;
            hashCode ^= hashCode >> 6;
        }
        hashCode += hashCode << 3;
        hashCode ^= hashCode >> 11;
        hashCode += hashCode << 15;
        return hashCode & Integer.MAX_VALUE;
    }

    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            char[] newChars = new char[newCapacity];
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    newChars[i] = LispCharacter.getValue(list.car());
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    newChars[i] = LispCharacter.getValue(initialContents.elt(i));
                }
            } else {
                Lisp.type_error(initialContents, Symbol.SEQUENCE);
            }
            this.chars = newChars;
        } else {
            if (this.chars == null) {
                this.chars = new char[newCapacity];
                int limit = Math.min(this.capacity, newCapacity);
                if (this.array instanceof AbstractString) {
                    AbstractString string = (AbstractString)this.array;
                    for (int i = 0; i < limit; ++i) {
                        this.chars[i] = string.charAt(this.displacement + i);
                    }
                } else {
                    for (int i = 0; i < limit; ++i) {
                        LispCharacter character = (LispCharacter)this.array.AREF(this.displacement + i);
                        this.chars[i] = character.value;
                    }
                }
            } else if (this.capacity != newCapacity) {
                char[] newElements = new char[newCapacity];
                System.arraycopy(this.chars, 0, newElements, 0, Math.min(this.capacity, newCapacity));
                this.chars = newElements;
            }
            if (initialElement != null && this.capacity < newCapacity) {
                char c = LispCharacter.getValue(initialElement);
                for (int i = this.capacity; i < newCapacity; ++i) {
                    this.chars[i] = c;
                }
            }
        }
        this.capacity = newCapacity;
        this.array = null;
        this.displacement = 0;
        this.isDisplaced = false;
        return this;
    }

    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        this.capacity = newCapacity;
        this.array = displacedTo;
        this.displacement = displacement;
        this.chars = null;
        this.isDisplaced = true;
        return this;
    }
}

